/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.PacketSendResultToClient;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketGetListFromServer {
    protected final ResourceKey<Level> dimension;
    protected final BlockPos pos;
    protected final String command;
    protected final TypedMap params;

    public PacketGetListFromServer(FriendlyByteBuf buf) {
        this.dimension = LevelTools.getId(buf.m_130281_());
        this.pos = buf.m_130135_();
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
    }

    public PacketGetListFromServer(ResourceKey<Level> dimension, BlockPos pos, String cmd, @Nonnull TypedMap params) {
        this.dimension = dimension;
        this.pos = pos;
        this.command = cmd;
        this.params = params;
    }

    public PacketGetListFromServer(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        this.dimension = SafeClientTools.getWorld().m_46472_();
        this.pos = pos;
        this.command = cmd;
        this.params = params;
    }

    public PacketGetListFromServer(BlockPos pos, String cmd) {
        this.dimension = SafeClientTools.getWorld().m_46472_();
        this.pos = pos;
        this.command = cmd;
        this.params = TypedMap.EMPTY;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            ServerLevel world = LevelTools.getLevel(ctx.getSender().m_20193_(), this.dimension);
            if (world.m_46805_(this.pos)) {
                BlockEntity te = world.m_7702_(this.pos);
                if (te instanceof GenericTileEntity) {
                    GenericTileEntity generic = (GenericTileEntity)te;
                    CommandInfo info = McJtyLib.getCommandInfo(this.command);
                    if (info == null) {
                        throw new IllegalStateException("Command '" + this.command + "' is not registered!");
                    }
                    Class type = info.type();
                    List list = generic.executeServerCommandList(this.command, (Player)player, this.params, type);
                    McJtyLib.networkHandler.sendTo((Object)new PacketSendResultToClient(this.pos, this.command, list), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                } else {
                    Logging.logError("Command '" + this.command + "' not handled!");
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

